﻿<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Fundusz - udzielone pożyczki</title>
		<script runat="server">

	[DefaultWidth(19)]
	public enum TypZakresu {
		Wszystkie, Spłacone, Niespłacone
	}
	
	public class PrnParams: ContextBase {
		public PrnParams(Context context): base(context) {
            if (context.Contains(typeof(ActualOkres)))
                Okres = ((ActualOkres)context[typeof(ActualOkres)]).Okres;
            else
                Okres = FromTo.Empty;
        }
		
		TypZakresu zakres = TypZakresu.Niespłacone;
		[Caption("Zakres")]
        [Priority(1)]
		public TypZakresu Zakres {
			get { return zakres; }
			set { 
				zakres = value; 
				OnChanged(EventArgs.Empty);
			}
		}


        FromTo okres;
        [Caption("Za okres")]
        [Priority(2)]
        public FromTo Okres {
            get { return okres; }
            set {
                if (value == FromTo.Empty)
                    value = new YearMonth(ActualDate.Today(Context)).ToFromTo();
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }        
	}
	
	PrnParams pars = null; 
	[Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	} 
	
	Pozyczka.PożyczkaWorker worker = new Pozyczka.PożyczkaWorker();
	
	void OnContextLoad(object sender, EventArgs args) {
		DefinicjaFunduszuPozyczkowego def = (DefinicjaFunduszuPozyczkowego)dc[typeof(DefinicjaFunduszuPozyczkowego)];
		ReportHeader1["FUNDUSZ"] = def==null ? "?" : def.ToString();
        ReportHeader1["OKRES"] = pars.Okres.ToString();        
		
		ArrayList result = new ArrayList();
		Row[] rows = (Row[])dc[typeof(Row[])];	
		foreach (FundPozyczkowy fp in rows)
            foreach (Pozyczka p in fp.Pozyczki) {
                if (!pars.Okres.Contains(p.Data))
                    continue;
                switch (pars.Zakres) {
                    case TypZakresu.Spłacone:
                        if (p.Splacona)
                            result.Add(p);
                        break;
                    case TypZakresu.Niespłacone:
                        if (!p.Splacona)
                            result.Add(p);
                        break;
                    default:
                        result.Add(p);
                        break;
                }
            }
		Grid1.DataSource = result;
	}

    void OnBeforeRow(object sender, RowEventArgs args) {
		worker.Pożyczka = (Pozyczka)args.Row;
		spłaty.EditValue = worker.Spłaty;
		pozostaje.EditValue = worker.Pozostaje;
    }

		</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="FunduszUdzielonePozyczki" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business" oncontextload="OnContextLoad"></ea:datacontext>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title='%FUNDUSZ% - UDZIELONE POŻYCZKI|W okresie: %OKRES%' runat="server"></cc1:ReportHeader>
			<ea:Grid id="Grid1" runat="server" OnBeforeRow="OnBeforeRow" RowTypeName="Soneta.Kadry.Pozyczka,Soneta.KadryPlace">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
					<ea:GridColumn Width="15" DataMember="Fundusz.Pracownik.Kod" Caption="Kod" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn Width="35" DataMember="Fundusz.Pracownik.NazwiskoImię" Caption="Nazwisko i imię" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn DataMember="Data" Total="Info" Caption="Pożyczka~Data udzielenia"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" DataMember="Kwota" Total="Sum" Caption="Pożyczka~Kwota" Format="{0:n}"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Pożyczka~Spłaty" Format="{0:n}" ID="spłaty"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Pożyczka~Pozostaje" Format="{0:n}" ID="pozostaje"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
		</form>
	</body>
</HTML>

